
*****************************************************************************************************
***     ANALYSIS: "Stable relationships, stable participation?"			      					  ***
***		DATA:  - Pairfam waves 1 to 6, Release 6.0 								   			   	  ***
***			   - Paradata waves 3 to 7 (available upon request) 					    		  ***
***																				   			      ***	
*** 	CONTENT: Section 4.3 Effects of reported separation	   						   		   	  ***
***		   	   - Effects on participation, full sample (model 1, Figure 1)	   		   		      ***	
***		  	   - Effects on participation, two consecutive observations & partner      		   	  ***
***			     in wave t-2 (models 2 & 3, Figure 1)								   			  ***
***		       - Effects on contact & cooperation (models 4-7, Figure 2; Appendix Table A2) 	  ***
*****************************************************************************************************

clear all
set maxvar 10000
set more off
set varabbrev off

global path1 `""datapath""' 
cd $path1	


*** Model 1: Effects of separation in wave t-1 on participation in wave t

** Sample: Full sample
use attrition_full, clear	
drop if waveb==1					// dependent variables waves 3 to 7 
		
** Number of missing values 
misschk hpsep age woman kidsalv yeduc10 migstatus house workedu relstatn inr_intim inr_hhinc pct_inr nbitems wave, gen(miss)

logit presponse hpsep c.age##c.age i.relstatn woman kidsalv yeduc10 i.migstatus house i.workedu ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems ib(last).wave, vce(cluster id)
margins, dydx(*) post
estimates store full


*** Models 2 & 3: Effects of separation in wave t-1 on participation in wave t by relationship status

** Sample: Two consecutive observations & partner in wave t-2
use attrition_restr.dta, clear
drop if waveb==1					// dependent variables waves 3 to 7 

** Number of missing values 
cap drop miss*
misschk hpsep age reldur_yattr woman cohabattr kidsalv yeduc10 migstatus house changework moves workedu inr_intim inr_hhinc pct_inr nbitems wave ///
		, gen(miss)

* (2) Cohabiting 
logit presponse hpsep c.age##c.age reldur_yattr ///
		woman kidsalv yeduc10 i.migstatus house changework moves i.workedu ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems ib(last).wave if cohabattr==1, vce(cluster id)
margins, dydx(*) post
estimates store cohab
	
* (3) LAT 
logit presponse hpsep c.age##c.age reldur_yattr ///
		woman kidsalv yeduc10 i.migstatus house changework moves i.workedu ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems ib(last).wave if latattr==1, vce(cluster id)
margins, dydx(*) post
estimates store LAT

** Figure 1: Effects of separation in wave t-1 on participation in wave t
coefplot full, bylabel("{bf: (1) Overall}") || cohab, bylabel("{bf: (2) Cohabiting}")  || LAT,bylabel("{bf: (3) Living Apart Together}") ||, ///
	drop(_cons age age2 reldur_yattr nbitems nbitems2 *wave) ///
	xline(0,lwidth(vthin) lcolor(black) lpattern(dash))  byopts(xrescale row(1) graphregion(color(white)))  ///
	mcolor(black) msize(small) ///
	subtitle (,  margin(medium) size(small) fcolor(white) lcolor(white)) ///
	ciopts(lcolor(black) lwidth(thin)) ///
	ylabel(,labsize(small)) ///
	xlabel(,labsize(small)) ///
	headings (2.workedu="{it: Employment (base: full-time)}" 2.relstatn="{it: Relationship status (base: single)}", nogap labsize(small)) ///
	xlabel(-0.1(0.05)0.1, grid) /// 
	ytitle ("", margin(vsmall))	///
	coeflabel(, wrap(35))	///
	xtitle("Average Marginal Effects on Participation & 95% CI's", margin(medsmall) size(small)) ///
	order(hpsep . *relstatn  . kidsalv woman . yeduc10 *migstatus house . *workedu . changework moves . inr_intim inr_hhinc pct_inr) 

	

*** Models 4-7: Effects of separation in wave t-1 on contact and cooperation probability in wave t by relationship status
logit pcontact hpsep c.age##c.age kidsalv woman i.migstatus house i.workedu changework moves ib(last).wave if cohabattr==1, vce (cluster id)
margins, dydx(*) post
estimates store Contact1
	
logit pcontact hpsep c.age##c.age kidsalv woman i.migstatus house i.workedu changework moves ib(last).wave if latattr==1, vce (cluster id)
margins, dydx(*) post
estimates store Contact2

logit pcoop hpsep c.age reldur_yattr kidsalv woman yeduc10 i.migstatus i.workedu changework ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems ib(last).wave if cohabattr==1, vce(cluster id)
margins, dydx(*) post
estimates store Cooperation1
	
logit pcoop hpsep c.age reldur_yattr kidsalv woman yeduc10 i.migstatus i.workedu changework ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems ib(last).wave if latattr==1, vce(cluster id)
margins, dydx(*) post
estimates store Cooperation2

** Figure 2: Effects of separation in wave t-1 on contact and cooperation probability in wave t by relationship status
coefplot (Contact1) (Cooperation1),  bylabel("{bf: Cohabiting}") || (Contact2)  (Cooperation2), bylabel("{bf: Living Apart Together}") ///
	keep(hpsep) aspectratio(.5)    ///
	xline(0,lwidth(vthin) lcolor(black) lpattern(dash))  byopts(legend(off) xrescale graphregion(color(white)))  ///
	subtitle (,  margin(medium) size(medsmall) fcolor(white) lcolor(white)) ///
	xlabel(,labsize(medsmall)) ///
	ylabel(`""' "", labsize(medsmall)) ///
	xlabel(-0.1(0.05)0.1, grid) /// 
	ytitle ("", margin(vsmall))	///
	mcolor(black)  ///
	ciopts(lcolor(black) lwidth(thin)) ///) ///
	coeflabel(, wrap(35))	///
	xtitle("Average Marginal Effects of Separation & 95% CI's", margin(medsmall) size(small)) ///
	graphregion(color(white))


*** Appendix tabel A2: Effects of separation in wave t-1 on contact and cooperation probability in wave t by relationship status
esttab 	Contact1 Contact2 Cooperation1 Cooperation2 using "outputpath", ///
		r2 b(3) se(3) label star(+ 0.10 * 0.05 ** 0.01 *** 0.001) ///
		stats(r2_p N, fmt(%9.3f %9.0g) labels(Pseudo R-squared)) ///
		varlabels(_cons Constant) posthead("") ///
		mtitles ("Contact Cohabiting" "Contact LAT" "Cooperation Cohabiting" "Cooperation LAT") replace


*** Including multiplicative interaction terms for respondents commitment to the panel study 
	
** Cohabiting
logit pcoop i.hpsep age reldur_yattr kidsalv woman yeduc10 i.migstatus i.workedu changework ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems ib(last).wave if cohabattr==1
estimates store null
logit pcoop i.hpsep##ib(last).wave age reldur_yattr kidsalv woman yeduc10 i.migstatus i.workedu changework ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems if cohabattr==1
estimates store full
lrtest null full         

logit pcoop i.hpsep age reldur_yattr kidsalv woman yeduc10 i.migstatus i.workedu changework  ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems ib(last).wave if cohabattr==1
fitstat, saving(mod1)            
logit pcoop i.hpsep##ib(last).wave age reldur_yattr kidsalv woman yeduc10 i.migstatus i.workedu changework ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems if cohabattr==1
fitstat, using(mod1)             

logit pcoop i.hpsep age reldur_yattr kidsalv woman yeduc10 i.migstatus i.workedu changework ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems ib(last).wave if cohabattr==1, vce(cluster id)
margins ib(last).wave#i.hpsep             
marginsplot,     title("")                            ///
   plot1opts(connect(i) mcolor(gs9)) ci1opts (lcolor(gs9))                         ///
   plot2opts(connect(i) mcolor(gs3)) ciopts (lcolor(gs3))        ///  
    title ("Predicted Probabilities by Length of Panel Participation", size(med)) ///
	ytitle("P(Cooperation LAT)", size(med))                              ///  
	ylabel(0(0.2)1, format(%9.1f) labsize(medsmall) angle(horizontal) grid) ///
	xlabel(,labsize(medsmall)) ///
	xtitle("", )             /// 
	legend(bmargin(medsmall) margin(tiny) row(2) order(1 2)  lab(1 "No Separation")        ///
          lab(2 "Separation")  size(med))                           ///
	graphregion(color(white)) 
	
logit pcoop i.hpsep##ib(last).wave age reldur_yattr kidsalv woman yeduc10 i.migstatus i.workedu changework ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems if cohabattr==1, vce(cluster id)
contrast hpsep##wave
margins ib(last).wave#i.hpsep             		 
marginsplot,   plotopts(connect(i))   title("")                            ///
   plot1opts(connect(i) mcolor(gs9)) ci1opts (lcolor(gs9))                         ///
   plot2opts(connect(i) mcolor(gs3)) ciopts (lcolor(gs3))        ///   
	ytitle("P (Cooperation)", size(medsmall))                              ///  
	ylabel(0(0.2)1, format(%9.1f) labsize(medsmall) angle(horizontal) grid) ///
	xlabel(,labsize(medsmall)) ///
	xtitle("", )             /// 
	legend(bmargin(medsmall) margin(tiny) row(2) order(1 2)  lab(1 "No Separation")        ///
          lab(2 "Separation")  size(med))                             ///
	graphregion(color(white)) 
	

** LAT
logit pcoop i.hpsep age reldur_yattr kidsalv woman yeduc10 i.migstatus i.workedu changework ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems ib(last).wave if latattr==1
estimates store null
logit pcoop i.hpsep##ib(last).wave age reldur_yattr kidsalv woman yeduc10 i.migstatus i.workedu changework ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems if latattr==1
estimates store full
lrtest null full         

logit pcoop i.hpsep age reldur_yattr kidsalv woman yeduc10 i.migstatus i.workedu changework  ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems ib(last).wave if latattr==1
fitstat, saving(mod1)            
logit pcoop i.hpsep##ib(last).wave age reldur_yattr kidsalv woman yeduc10 i.migstatus i.workedu changework ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems if latattr==1
fitstat, using(mod1)             

logit pcoop i.hpsep age reldur_yattr kidsalv woman yeduc10 i.migstatus i.workedu changework ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems ib(last).wave if latattr==1, vce(cluster id)
margins ib(last).wave#i.hpsep             
marginsplot,     title("")                            ///
   plot1opts(connect(i) mcolor(gs9)) ci1opts (lcolor(gs9))                         ///
   plot2opts(connect(i) mcolor(gs3)) ciopts (lcolor(gs3))        ///  
    title ("Predicted Probabilities by Length of Panel Participation", size(med)) ///
	ytitle("P(Cooperation LAT)", size(med))                              ///  
	ylabel(0(0.2)1, format(%9.1f) labsize(medsmall) angle(horizontal) grid) ///
	xlabel(,labsize(medsmall)) ///
	xtitle("", )             /// 
	legend(bmargin(medsmall) margin(tiny) row(2) order(1 2)  lab(1 "No Separation")        ///
          lab(2 "Separation")  size(med))                           ///
	graphregion(color(white)) 

logit pcoop i.hpsep##ib(last).wave age reldur_yattr kidsalv woman yeduc10 i.migstatus i.workedu changework ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems if latattr==1, vce(cluster id)
contrast hpsep##wave
margins ib(last).wave#i.hpsep             		 
marginsplot,   plotopts(connect(i))   title("")                            ///
   plot1opts(connect(i) mcolor(gs9)) ci1opts (lcolor(gs9))                         ///
   plot2opts(connect(i) mcolor(gs3)) ciopts (lcolor(gs3))        ///   
	ytitle("P (Cooperation)", size(medsmall))                              ///  
	ylabel(0(0.2)1, format(%9.1f) labsize(medsmall) angle(horizontal) grid) ///
	xlabel(,labsize(medsmall)) ///
	xtitle("", )             /// 
	legend(bmargin(medsmall) margin(tiny) row(2) order(1 2)  lab(1 "No Separation")        ///
          lab(2 "Separation")  size(med))                             ///
	graphregion(color(white)) 
	
